package book.beans;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.view.ViewScoped;
import javax.inject.Named;

/**
 *
 * @author Leonard
 */
@Named
@ViewScoped
public class PlayersBean implements Serializable {

    private static final Logger logger = Logger.getLogger(PlayersBean.class.getName());
    HashMap<String, Players> dataHashMap = new HashMap<>();
    final SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
    String selectedPlayerKey;

    public PlayersBean() {
        try {
            dataHashMap.put("2", new Players(2, "NOVAK DJOKOVIC", (byte) 26, "Belgrad, Serbia", "Monte Carlo, Monako", (short) 188, (byte) 80, "Boris Becker, Marian Vajda", sdf.parse("22.05.1987")));
            dataHashMap.put("1", new Players(1, "RAFAEL NADAL", (byte) 27, "Manacor, Majorka, Hiszpania", "Manacor, Majorka, Hiszpania", (short) 185, (byte) 85, "Toni Nadal", sdf.parse("03.06.1986")));
            dataHashMap.put("7", new Players(7, "TOMAS BERDYCH", (byte) 28, "Valasske Mezirici, Czechy", "Monte Carlo, Monako", (short) 196, (byte) 91, "Tomas Krupa", sdf.parse("17.09.1985")));
            dataHashMap.put("8", new Players(8, "STANISLAS WAWRINKA", (byte) 28, "Lozanna, Szwajcaria", "St. Barthelemy, Szwajcaria", (short) 183, (byte) 81, "Magnus Norman", sdf.parse("28.03.1985")));
            dataHashMap.put("4", new Players(4, "ANDY MURRAY", (byte) 26, "Dunblane, Szkocja", "Londyn, Anglia", (short) 190, (byte) 84, "Ivan Lendl", sdf.parse("15.05.1987")));
            dataHashMap.put("5", new Players(5, "JUAN MARTIN DEL POTRO", (byte) 25, "Tiil, Argentyna", "Tiil, Argentyna", (short) 198, (byte) 97, "Franco Davin", sdf.parse("23.09.1988")));
            dataHashMap.put("10", new Players(10, "JO-WILFRIED TSONGA", (byte) 28, "Le Mans, Francja", "Gingins, Szwajcaria", (short) 188, (byte) 91, "Nicolas Escude i Thierry Ascione", sdf.parse("17.04.1985")));
            dataHashMap.put("6", new Players(6, "ROGER FEDERER", (byte) 32, "Basel, Szwajcaria", "Bottmingen, Szwajcaria", (short) 185, (byte) 85, "Stefan Edberg, Severin Luthi", sdf.parse("08.08.1981")));
            dataHashMap.put("9", new Players(9, "RICHARD GASQUET", (byte) 27, "Beziers, Francja", "Neuchatel, Szwajcaria", (short) 185, (byte) 75, "Sergi Bruguera i Sebastien Grosjean", sdf.parse("18.06.1986")));
            dataHashMap.put("3", new Players(3, "DAVID FERRER", (byte) 31, "Javea, Hiszpania", "Walencja, Hiszpania", (short) 175, (byte) 73, "Jose Francisco Altur", sdf.parse("02.04.1982")));

        } catch (ParseException ex) {
            Logger.getLogger(PlayersBean.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String getSelectedPlayerKey() {
        return selectedPlayerKey;
    }

    public void setSelectedPlayerKey(String selectedPlayerKey) {
        this.selectedPlayerKey = selectedPlayerKey;
    }

    public HashMap<String, Players> getDataHashMap() {
        return dataHashMap;
    }

    public void setDataHashMap(HashMap<String, Players> dataHashMap) {
        this.dataHashMap = dataHashMap;
    }

    public void showSelectedPlayer() {
        Players player = dataHashMap.get(selectedPlayerKey);

        if (player != null) {
            logger.log(Level.INFO, "Wybrano gracza:{0}", player.getPlayer());
        } else {
            logger.log(Level.INFO, "Nie wybrano żadnego gracza!");
        }        
    }
}
